import pandas

# Stap 1: Lees het CSV-bestand in een pandas DataFrame
DataFrame = pandas.read_csv("youtubers.csv")

# Stap 2: Verwijder komma's uit de “subscribers”, "video views" en “video count” kolommen en converteer naar numerieke waarden
DataFrame["subscribers"] = DataFrame["subscribers"].str.replace(",", "").astype(float)
DataFrame["video views"] = DataFrame["video views"].str.replace(",", "").astype(float)
DataFrame["video count"] = DataFrame["video count"].str.replace(",", "").astype(float)

# Stap 3: Bereken het totale aantal video views van de top 5 Youtubers
totale_views_top_5 = DataFrame.head(5)["video views"].sum()
print(totale_views_top_5)

# Stap 4: Maak een barplot van de top 5 Youtubers
import matplotlib.pyplot as pyplot

pyplot.bar(DataFrame.head(5)["Youtuber"], DataFrame.head(5)["subscribers"])
pyplot.xlabel("Youtuber")
pyplot.ylabel("Aantal abonnees")
pyplot.title("Top 5 Youtubers")
pyplot.show()

# Stap 5: Bereken het gemiddelde aantal video views per video voor elke Youtuber in de top 5
DataFrame["gemiddelde views per video"] = DataFrame["video views"] / DataFrame["video count"]
print(DataFrame["gemiddelde views per video"])

# Stap 6: Maak een nieuwe DataFrame met alleen de Youtubers in de categorie "Music"
DataFrame_muziek = DataFrame[DataFrame["category"] == "Music"]
print(DataFrame_muziek)

# Stap 7: Bereken het gemiddelde aantal abonnees en video views voor de Youtubers in de categorie "Music"
gemiddelde_abonnees_music = DataFrame_muziek["subscribers"].mean()
gemiddelde_views_music = DataFrame_muziek["video views"].mean()
print(gemiddelde_abonnees_music)
print(gemiddelde_views_music)

# Stap 8: Exporteer de resultaten van de Youtubers in de categorie "Music" naar een nieuw CSV-bestand
DataFrame_muziek.to_csv("youtubers_music.csv", index=False)